/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/   
/**
 * \file    main.c
 *
 * \brief   Entry point for DDR test application
 *
 * This file contains the entry point function for DDR Test application.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

/*
 *  DM814X Test Suite
 *
 */
/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_EVM.h"
#include "DM814x_types.h"
#include "stdio.h"
#include "stdlib.h"

/*
 *====================
 * Function implementations
 *====================
 */
void TEST_execute( STATUS ( *funchandle )( INT16 cache_enable), char *testname, INT16 testid )
{
    STATUS status;

    /* Display test ID */
    printf( "%02d  Testing %s...\n", testid, testname );

    /* Call test function */
    if (testid)
		status = funchandle(1);
    else
    	status = funchandle(0);

    /* Check for test fail */
    if ( status != 0 )
    {
        /* Print error message */
        printf( "     FAIL... error code %d... quitting\n", status );

    }
    else
    {
        /* Print error message */
        printf( "    PASS\n" );
    }
}

extern STATUS ddr3_test(INT16 cache_enable);

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  main( )                                                                 *
 *                                                                          *
 * ------------------------------------------------------------------------ */
void main(void)
{
    
    /* Initialize EVM */
	DM814x_EVM_Init ();

	TEST_execute( ddr3_test,  "ddr3Test", 0 );

    printf( "\n***ALL Tests Done***\n" );

}
